<?php
$path_local_raiz = '../../';
require_once($path_local_raiz.'core/sec.php');

$dti = fgpa('i');
$dtf = fgpa('f');
$idin = 0;
$idfi = 150;
$sexo = 'A';
$qtd = 100;

$rs = $con->prepare("SELECT * FROM cidadao_tb_cf_hiperutilizador WHERE id = ? AND ibge = ?");
$rs->bindParam(1,$_SESSION['login']);
$rs->bindParam(2,$_SESSION['ibge']);
if($rs->execute()){
	if($rs->rowCount() > 0){
		while($row = $rs->fetch(PDO::FETCH_OBJ)){
			$dti = $row->dti;
			$dtf = $row->dtf;
            $idin = $row->idin;
            $idfi = $row->idfi;
            $sexo = $row->sexo;
            $qtd = $row->qtd;
		}
	}
}

$dtif = datanas6($dti).' - '.datanas6($dtf);

?>
<!-- Basic Inputs start -->
<section id="basic-input">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header border-bottom">
                  <h4 class="card-title">Hiperutilizador</h4>
                </div>
                <div class="card-body mt-2">
                  <p class="card-text">Relatório de apoio para hiperutilizador</p>
                  <form class="dt_adv_search" name="frm" id="frm" method="POST">
                    <div class="row g-1 mb-md-1">
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label" for="dtif">Data de Inicio e Data de Fim</label>
                                <input type="text" class="form-control float-right" name="dtif" id="dtif" />
                            </div>
                        </div>
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="mb-1">
                                <label class="form-label">Sexo</label>
                                <select class="form-select" aria-label="Default select example" name="sexo" id="sexo">
                                <?php
                                    if ($sexo == 'A'){
                                        echo "
                                        <option value=\"A\" selected>Ambos</option>
                                        <option value=\"M\">Masculino</option>
                                        <option value=\"F\">Feminino</option>
                                        ";
                                    } elseif ($sexo == 'M') {
                                        echo "
                                        <option value=\"A\">Ambos</option>
                                        <option value=\"M\" selected>Masculino</option>
                                        <option value=\"F\">Feminino</option>
                                        ";
                                    } else {
                                      echo "
                                      <option value=\"A\">Ambos</option>
                                      <option value=\"M\">Masculino</option>
                                      <option value=\"F\" selected>Feminino</option>
                                      ";
                                    }
                                ?>
				                        </select>
                            </div>
                        </div>
                        <div class="col-xl-2 col-md-6 col-12">
                            <label class="form-label" for="idin">Idade inicial (anos)</label>
				                    <input type="text" class="form-control" name="idin" id="idin" value="<?php echo $idin;?>">
                        </div>
                        <div class="col-xl-2 col-md-6 col-12 mb-1 mb-md-0">
                            <label class="form-label" for="idfi">Idade final (anos)</label>
                            <input type="text" class="form-control" name="idfi" id="idfi" value="<?php echo $idfi;?>" />
                        </div>
                        <div class="col-xl-6 col-md-6 col-12">
                            <label class="form-label" for="qtd">Quantidade</label>
                            <input type="text" class="form-control" name="qtd" id="qtd" value="<?php echo $qtd;?>" /><br>
                        </div>

                        <button type="submit" class="btn btn-primary" id="button-addon2">Gravar e gerar</button>
                    </div>

                  </form>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
$(function () {
  $('#dtif').daterangepicker({
	  startDate: '<?php echo datanas6($dti);?>',
	  endDate: '<?php echo datanas6($dtf);?>',
      locale: {
        format: 'DD/MM/YYYY'
      }
  });
  $('#frm').validate({
    submitHandler: function (form) {
      $.post('mod/cidadao/gv_hiperutilizador.php', $('#frm').serialize(), function (data, textStatus) {
        if (data == 'Ok'){ // data.substring(0,2)
          //swal.fire('Ok!','Gravado com sucesso!','success');
          SlickLoader.enable();
          $('.content-body').load('mod/cidadao/rel_hiperutilizador.php');
        } else {
          swal.fire('erro!',data,'error');
        }
      });
    },
    rules: {
        idfi: {
          required: true,
          number:true
        },
        idin: {
          required: true,
          number:true
        },
        qtd: {
          required: true,
          number:true
        }
    },
    messages: {
        idfi: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        idin: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        },
        qtd: {
          required: "Este campo é necessário",
          number: "Deve ser número inteiro"
        }
    }
  });
})
</script>