<?php
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//    
//    
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

// Retorna o dia da semana sendo 0 = domingo ..., date(w)
// ###############################################################################################################################################
function diasemana($ds,$tp="a"){ 
	$diasemana = ""; 
	switch ($ds) {
		case 0:
			if ($tp == 'a'){
				$diasemana = "Dom";
			} else {
				$diasemana = "Domingo";
			}
			break;
		case 1:
			if ($tp == 'a'){
				$diasemana = "Seg";
			} else {
				$diasemana = "Segunda-feira";
			}
			break;
		case 2:
			if ($tp == 'a'){
				$diasemana = "Ter";
			} else {
				$diasemana = "Terça-feira";
			}
			break;
		case 3:
			if ($tp == 'a'){
				$diasemana = "Qua";
			} else {
				$diasemana = "Quarta-feira";
			}
			break;
		case 4:
			if ($tp == 'a'){
				$diasemana = "Qui";
			} else {
				$diasemana = "Quinta-feira";
			}
			break;
		case 5:
			if ($tp == 'a'){
				$diasemana = "Sex";
			} else {
				$diasemana = "Sexta-feira";
			}
			break;
		case 6:
			if ($tp == 'a'){
				$diasemana = "Sab";
			} else {
				$diasemana = "Sábado";
			}
			break;
	}
	return $diasemana;
}
// Transforma data  DD/MM/AAAA em data AAAA-MM-DD
// ###############################################################################################################################################
function datanas1($data){  
	$pos = strpos($data,'/');
	if ($pos === false) {
		$ndi = '0000-00-00';
	} else {
		$dts = explode('/',$data);
		$ndi = $dts[2].'-'.$dts[1].'-'.$dts[0];
	}

	return $ndi;
}
// Transforma data AAAA-MM-DD em data DD/MM/AAAA
// ###############################################################################################################################################
function datanas2($data){  
	$pos = strpos($data,'-');
	if ($pos === false) {
		$ndi = '00/00/0000';
	} else {
		$dts = explode('-',$data);
		$ndi = $dts[2].'/'.$dts[1].'/'.$dts[0];
	}

	return $ndi;
}
// Transforma data AAAA-MM-DD em data AAAAMMDD
// ###############################################################################################################################################
function datanas3($data){  
	$pos = strpos($data,'-');
	if ($pos === false) {
		$ndi = 0;
	} else {
		$dts = explode('-',$data);
		$ndi = (int) $dts[0].$dts[1].$dts[2];
	}
	return $ndi;
}
// Transforma data  DD/MM/AAAA em data AAAAMMDD
// ###############################################################################################################################################
function datanas4($data){  
	$pos = strpos($data,'/');
	if ($pos === false) {
		$ndi = 0;
	} else {
		$dts = explode('/',$data);
		$ndi = (int) $dts[2].$dts[1].$dts[0];
	}

	return $ndi;
}
// Transforma data  AAAAMMDD em data DDMMAAAA
// ###############################################################################################################################################
function datanas5($data){  
	$ano = substr($data,0,4);
	$mes = substr($data,4,2);
	$dia = substr($data,6,2);
	$datafinal = $dia.$mes.$ano;

	return $datafinal;
}
// Transforma data  AAAAMMDD em data DD/MM/AAAA
// ###############################################################################################################################################
function datanas6($data){  
	$ano = substr($data,0,4);
	$mes = substr($data,4,2);
	$dia = substr($data,6,2);
	$datafinal = $dia."/".$mes."/".$ano;

	return $datafinal;
}
// Transforma data  AAAAMMDD em data AAAA-MM-DD
// ###############################################################################################################################################
function datanas7($data){  
	$ano = substr($data,0,4);
	$mes = substr($data,4,2);
	$dia = substr($data,6,2);
	$datafinal = $ano."-".$mes."-".$dia;

	return $datafinal;
}
// Transforma data DDMMAAAA em data AAAAMMDD
// ###############################################################################################################################################
function datanas8($data){  
	$dia = substr($data,0,2);
	$mes = substr($data,2,2);
	$ano = substr($data,4,4);
	$datafinal = $ano.$mes.$dia;

	return $datafinal;
}
// Transforma hora HH:MM:SS em inteiro HHMMSS
// ###############################################################################################################################################
function horaint($hora){  
	$pos = strpos($hora,':');
	if ($pos === false) {
		$nhi = 0;
	} else {
		$har = explode(':',$hora);
		$nhi = (int) $har[0].$har[1].$har[2];
	}
	return $nhi;
}
// Compara duas datas
// ###############################################################################################################################################
function cmp($a, $b) {
	return $a['data'] > $b['data'];
}
// Verifica se é uma hora válida
// ###############################################################################################################################################
function ehora($hora) {
	$resultado = false;
	if (strlen($hora) >= 3){
		if (str_contains($hora, ":")){
			$ar_hora = explode(":",$hora);
			if (count($ar_hora) == 2){
				if (is_numeric($ar_hora[0])){
					if ($ar_hora[0] >= 0 && $ar_hora[0] <= 23){
						if (is_numeric($ar_hora[1])){
							if ($ar_hora[1] >= 0 && $ar_hora[1] <= 59){
								$resultado = true;
							}
						}
					}
				}
			}
		}	
	}
	return $resultado;
}
// Retorna a data inicial 'i' ou a data final 'f' do quadrimestre atual
// ###############################################################################################################################################
function fgpa($id='i',$ma=''){
	
	$pg_ano = date("Y");
	$pg_mes = date("m");
	if (strlen($ma) == 6){
		$pg_ano = substr($ma,0,4);
		$pg_mes = substr($ma,4,2);
	} elseif (strlen($ma) == 5){
		$pg_ano = substr($ma,0,4);
		$pg_mes = '0'.substr($ma,4,1);
	}
	
	$dti = '';
	$dtf = '';
	$ano = (int) $pg_ano;
	$quadrimestre = 1;
	switch ($pg_mes) {
	  case "01":
		$quadrimestre = 1;
		break;
	  case "02":
		$quadrimestre = 1;
		break;
	  case "03":
		$quadrimestre = 1;
		break;
	  case "04":
		$quadrimestre = 1;
		break;
	  case "05":
		$quadrimestre = 2;
		break;
	  case "06":
		$quadrimestre = 2;
		break;
	  case "07":
		$quadrimestre = 2;
		break;
	  case "08":
		$quadrimestre = 2;
		break;
	  case "09":
		$quadrimestre = 3;
		break;
	  case "10":
		$quadrimestre = 3;
		break;
	  case "11":
		$quadrimestre = 3;
		break;
	  case "12":
		$quadrimestre = 3;
		break;
	  default:
		$quadrimestre = 1;
	}
	if ($quadrimestre == 1){
		$dti = $ano.'0101';
		$dtf = $ano.'0430';
	}
	if ($quadrimestre == 2){
		$dti = $ano.'0501';
		$dtf = $ano.'0831';
	}
	if ($quadrimestre == 3){
		$dti = $ano.'0901';
		$dtf = $ano.'1231';
	}
	if ($id == 'i'){
		return (int) $dti;
	} else {
		return (int) $dtf;
	}
}
// Transforma uma data completa AAAA-MM-DD HH:MM:SS em vários formatos
// ###############################################################################################################################################
    /*
        AD = Apenas data (AAAA-MM-DD)
        AH = Apenas hora (HH:MM:SS)
        AHSS = Apenas hora sem segundos (HH:MM)
        HH = hora
        HM = Minuto
        HS = Segundo
        DD = dia
        DM = Mês
        DA = Ano (4 dígitos)
        DAA = Ano (2 dígitos)
        ADFN = Apenas data no formato numérico (AAAAMMDD)
        ADFB = Apenas data no formato brasileiro (DD/MM/AAAA)
        DHFB = Data e hora no formato brasileiro (DD/MM/AAAA HH:MM:SS)
    */
function ftimes($dh,$op='DHFB'){
	$retorno = "";
	if (strlen($dh) > 0){
		$op = strtoupper($op);
		$dh_a = explode(" ",$dh);
		$ad = $dh_a[0];
		$ah = $dh_a[1];
		$ah_a = explode(":",$ah);
		$hh = $ah_a[0];
		$hm = $ah_a[1];
		$hs = $ah_a[2];
		$ahss = $hh.":".$hm;
		$ad_a = explode("-",$ad);
		$da = $ad_a[0];
		$dm = $ad_a[1];
		$dd = $ad_a[2];
		$adfn = (int) $da.$dm.$dd;
		$daa = substr($da,-2);
		$adfb = $dd."/".$dm."/".$da;
		$dhfb = $adfb." ".$ah;
	
		switch ($op) {
			case 'AD':
				$retorno = $ad;
				break;
			case 'AH':
				$retorno = $ah;
				break;
			case 'AHSS':
				$retorno = $ahss;
				break;
			case 'HH':
				$retorno = $hh;
				break;
			case 'HM':
				$retorno = $hm;
				break;
			case 'HS':
				$retorno = $hs;
				break;
			case 'DD':
				$retorno = $dd;
				break;
			case 'DM':
				$retorno = $dm;
				break;
			case 'DA':
				$retorno = $da;
				break;
			case 'DAA':
				$retorno = $daa;
				break;
			case 'ADFN':
				$retorno = $adfn;
				break;
			case 'ADFB':
				$retorno = $adfb;
				break;
			case 'DHFB':
				$retorno = $dhfb;
				break;
			default:
				$retorno = $dhfb;
		}
	}
    return $retorno;
}
// Retorna o esquema vacinal detalhado
// ###############################################################################################################################################
function esq_vacina($ai,$mi,$di,$af,$mf,$df){
    $mensagem = '';
    // *****************************************************************************
    $mensagem_i = '';
    if ($ai > 0){
        $mensagem_i .= ">= ".$ai." anos";
        if ($mi > 0){
            $mensagem_i .= " e ".$mi." meses";
            if ($di > 0){
                $mensagem_i .= " e ".$di." dias";
            }
        } elseif ($di > 0) {
            $mensagem_i .= " e ".$di." dias";
        }
    } elseif ($mi > 0){
        $mensagem_i .= ">= ".$mi." meses";
        if ($di > 0){
            $mensagem_i .= " e ".$di." dias";
        }
    } elseif ($di > 0){
        $mensagem_i .= ">= ".$di." dias";
    }
    // *****************************************************************************
    $mensagem_f = '';
    $dia_f = '';
    if ($df < 30){
        $dia_f = $df." dias";
    }
    $sinal = '<=';
    $mes_f = '';
    if ($mf < 11){
        $mes_f = $mf." meses";
    } elseif ($mf == 11){
        $af++;
        $sinal = '<';
    }
    $ano_f = '';
    if ($af > 0 && $af < 999){
        $ano_f = $af." anos";
    }
    if (strlen($ano_f) > 0 || strlen($mes_f) > 0 || strlen($dia_f) > 0){
        $mensagem_f = $sinal;
        if (strlen($ano_f) > 0){
            $mensagem_f = $sinal.' '.$ano_f;
            if (strlen($mes_f) > 0){
                $mensagem_f = $sinal.' '.$ano_f.' e '.$mes_f;
                if (strlen($dia_f) > 0){
                    $mensagem_f = $sinal.' '.$ano_f.' e '.$mes_f.' e '.$dia_f;
                }
            } elseif (strlen($dia_f) > 0){
                $mensagem_f = $sinal.' '.$ano_f.' e '.$dia_f;
            }
        } elseif (strlen($mes_f) > 0){
            $mensagem_f = $sinal.' '.$mes_f;
            if (strlen($dia_f) > 0){
                $mensagem_f = $sinal.' '.$mes_f.' e '.$dia_f;
            }
        } elseif (strlen($dia_f) > 0){
            $mensagem_f = $sinal.' '.$dia_f;
        }
    }
    // *****************************************************************************
    $mensagem = $mensagem_i." | ".$mensagem_f;
    return $mensagem;
}
// Retorna o esquema vacinal detalhado em meses (retorna uma array)
// ###############################################################################################################################################
function tmp_vacina($ai,$mi,$di,$af,$mf,$df){
    $mensagem = array();
    // *****************************************************************************
    $tmeses_i = 0;
    if ($ai > 0){
        $tmeses_i += $ai * 12;
        if ($mi > 0){
            $tmeses_i += $mi;
            if ($di > 0){
                $tmeses_i += $di / 30;
            }
        } elseif ($di > 0) {
            $tmeses_i += $di / 30;
        }
    } elseif ($mi > 0){
        $tmeses_i += $mi;
        if ($di > 0){
            $tmeses_i += $di / 30;
        }
    } elseif ($di > 0){
        $tmeses_i += $di / 30;
    }
    // *****************************************************************************
    $tmeses_f = 0;
    $dia_f = 0;
    if ($df < 30){
        $dia_f = $df / 30;
    }
    $sinal = '<=';
    $mes_f = 0;
    if ($mf < 11){
        $mes_f = $mf;
    } elseif ($mf == 11){
        $af++;
        $sinal = '<';
    }
    $ano_f = 0;
    if ($af > 0 && $af < 999){
        $ano_f = $af * 12;
    }
    $tmeses_f = $ano_f + $mes_f + $dia_f;
    // *****************************************************************************
    $mensagem[0] = $sinal;
    $mensagem[1] = $tmeses_i;
    $mensagem[2] = $tmeses_f;
    return $mensagem;
}
// Completa com caracteres a esquerda ou a direita o número de vezes informado
// ###############################################################################################################################################
function completa($s,$t,$c=' ',$p='D'){ // completa($string,20,'@','E')
	$ns = '';
	if (strlen($s) == $t){
		$ns = $s;
	} else {
		if (strlen($s) > $t){
			$ns = substr($s,0,$t);
		} else {
			$dif = $t - strlen($s);
			$sc = '';
			for ($i=0;$i<$dif;$i++){
				$sc .= $c;
			}
			if ($p == 'D'){
				$ns = $s.$sc;
			} else {
				$ns = $sc.$s;
			}
		}
	}
	return $ns;
}
// Retorna o último dia do mês
// ###############################################################################################################################################
function udia($m,$a){
    $bis = (date('L', strtotime("$a-01-01")) ? true : false);
    $ud = '00';
    switch ($m) {
        case '01':
            $ud = '31';
            break;
        case '02':
            $ud = '28';
            if ($bis){
                $ud = '29';
            }
            break;
        case '03':
            $ud = '31';
            break;
        case '04':
            $ud = '30';
            break;
        case '05':
            $ud = '31';
            break;
        case '06':
            $ud = '30';
            break;
        case '07':
            $ud = '31';
            break;
        case '08':
            $ud = '31';
            break;
        case '09':
            $ud = '30';
            break;
        case '10':
            $ud = '31';
            break;
        case '11':
            $ud = '30';
            break;
        case '12':
            $ud = '31';
            break;
    }
    return $ud;
}
// Ordena uma array
// ###############################################################################################################################################
//print_r(array_sort($people, 'age', SORT_DESC)); // Sort by oldest first
//print_r(array_sort($people, 'surname', SORT_ASC)); // Sort by surname
/*
alternativa
$coluna = array_column($array, 'nome_coluna');
array_multisort($coluna, SORT_DESC, $array);

*/
function array_sort($array, $on, $order=SORT_ASC){
    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
                        $sortable_array[$k] = $v2;
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
            break;
            case SORT_DESC:
                arsort($sortable_array);
            break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}
// retorna a URL atual COMPLETA
// ###############################################################################################################################################
function url(){
	//$_SERVER['SERVER_NAME']
    if(isset($_SERVER['HTTPS'])){
        $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
    } else{
        $protocol = 'http';
    }
    return $protocol . "://" . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
}
// retorna a URL atual até o domínio
// ###############################################################################################################################################
function urls(){
	//$_SERVER['SERVER_NAME']
    if(isset($_SERVER['HTTPS'])){
        $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
    } else{
        $protocol = 'http';
    }
    return $protocol . "://" . $_SERVER['HTTP_HOST'];
}
// Exclui diretorios recursivamente
// ###############################################################################################################################################
function removeDirectory($path) {
	$files = glob($path . '/*');
	foreach ($files as $file) {
		is_dir($file) ? removeDirectory($file) : unlink($file);
	}
	rmdir($path);
	return;
}
// Deleta arquivos de com o nome indicado
// ###############################################################################################################################################
function delArqCor($caminho,$arquivo) {
	$files = glob($caminho.'/*');
	foreach ($files as $file) {
		if (strpos($file, $arquivo) !== false) {
			if (file_exists($file)){
				unlink($file);
			}
		}
	}
	return;
}
// Transforma uma hora HHMMSS em HH:MM:SS
// ###############################################################################################################################################
function hrshow($hora){ // 205545 -> 20:55:45
	if (strlen($hora) < 6){
		$hora = '0'.$hora;
	}
	$nhi = substr($hora,0,2).":".substr($hora,2,2).":".substr($hora,4,2);
	return $nhi;
}
// Completa com zeros a esquerda
// ###############################################################################################################################################
function zesq($num,$nz,$inc=0){
	$strfinal = '';
	$num = $num + $inc;
	if (strlen($num) < $nz){
		for ($i=0;$i<($nz-strlen($num));$i++){
			$strfinal = $strfinal."0";
		}
		$strfinal = $strfinal.$num;
	} else {
		$strfinal = $num;
	}
	return $strfinal;
}
// Função para verificar XML do CNES
// ###############################################################################################################################################
function cnes($fxm,$pcn,$pcb,$pioc,$ioc='I'){
	// cnes('xml/cnes.xml',$cns,$cbo,$cnes,'C')
	// cnes('xml/cnes.xml',$cns,$cbo,$ine,'I')
	$retorno = false;
	$p_cns = false;
	$p_ioc = false;
	$p_cbo = false;
	$sioc = '';
	$xml = simplexml_load_file($fxm);
	foreach($xml->IDENTIFICACAO->PROFISSIONAIS->DADOS_PROFISSIONAIS as $registro):
		if ($pcn == $registro['CO_CNS']){
			$p_cns = true;
		}
		foreach($registro->LOTACOES->DADOS_LOTACOES as $lota):
			if ($p_cns){
				if ($ioc == 'C'){
					$sioc = $lota['CNES'];
				} else {
					$sioc = $lota['CO_INE'];
				}
				if ($pioc == $sioc){
					$p_ioc = true;
				}
				if ($p_ioc){
					if ($pcb == $lota['CO_CBO']){
						$p_cbo = true;
					}
				}
			}
		endforeach;
	endforeach;
	if ($p_cns && $p_ioc && $p_cbo){
		$retorno = true;
	}
	return $retorno;
}
// Formata CNPJ colocando os pontos
// ###############################################################################################################################################
function mcnpj($num){
	$strfinal = '';
	if (strlen($num) < 14){
		for ($i=0;$i<(14-strlen($num));$i++){
			$strfinal = $strfinal."0";
		}
		$strfinal = $strfinal.$num;
	} else {
		$strfinal = $num;
	}
	$strfinal = substr($strfinal,0,2).".".substr($strfinal,2,3).".".substr($strfinal,5,3)."/".substr($strfinal,8,4)."-".substr($strfinal,12,2);
	return $strfinal;
}
// Formata código procedimento sigtap
// ###############################################################################################################################################
function msig($num){
	$strfinal = '';
	if (strlen($num) < 10){
		if (strlen($num) < 9){
			for ($i=0;$i<(10-strlen($num));$i++){
				$strfinal = $strfinal."0";
			}
			$strfinal = $strfinal.$num;
		} else {
			$strfinal = $num."0";
		}
	} else {
		$strfinal = $num;
	}
	$strfinal = substr($strfinal,0,2).".".substr($strfinal,2,2).".".substr($strfinal,4,2).".".substr($strfinal,6,3)."-".substr($strfinal,9,2);
	return $strfinal;
}
// Formata CPF colocando os pontos
// ###############################################################################################################################################
function mcpf($num){
	$strfinal = '';
	if (strlen($num) < 11){
		for ($i=0;$i<(11-strlen($num));$i++){
			$strfinal = $strfinal."0";
		}
		$strfinal = $strfinal.$num;
	} else {
		$strfinal = $num;
	}
	$strfinal = substr($strfinal,0,3).".".substr($strfinal,3,3).".".substr($strfinal,6,3)."-".substr($strfinal,9,2);
	return $strfinal;
}
// Formata o CNS colocando os pontos
// ###############################################################################################################################################
function mcns($num){
	$strfinal = '';
	if (strlen($num) < 15){
		for ($i=0;$i<(15-strlen($num));$i++){
			$strfinal = $strfinal."0";
		}
		$strfinal = $strfinal.$num;
	} else {
		$strfinal = $num;
	}
	/*
	$strfinal = substr($strfinal,0,3).".".substr($strfinal,3,4).".".substr($strfinal,7,4).".".substr($strfinal,11,4);
	return $strfinal;
	*/
	return substr($strfinal,0,3).".".substr($strfinal,3,4).".".substr($strfinal,7,4).".".substr($strfinal,11,4);
}
// Calcula a idade com uma data tipo int AAAAMMDD e uma data de referência que se não for informada será a data de HOJE
// ###############################################################################################################################################
function idadeint($data,$dtp=0){  // data int 20210225
	if ($dtp == 0){
		$dtp = date('Ymd');
	}
	$idade = 0;
	$ano = (int) substr($data,0,4);
	$mes = (int) substr($data,4,2);
	$dia = (int) substr($data,6,2);
	$ano_p = (int) substr($dtp,0,4);
	$mes_p = (int) substr($dtp,4,2);
	$dia_p = (int) substr($dtp,6,2);
	if ($ano_p >= $ano){
		$idade = $ano_p - $ano;
		if ($mes_p < $mes){
			$idade--;
		}
		if ($mes_p == $mes){
			if ($dia_p < $dia){
				$idade--;
			}
		}
	}
	return $idade;
}
// Calcula a idade com uma data tipo int AAAA-MM-DD e uma data de referência que se não for informada será a data de HOJE - retorna array (ano,mes,dia)
// ###############################################################################################################################################
function idadearray($data,$dtp=0){ // data int 2021-02-25
	$dob = new DateTime($data);
	if ($dtp == 0){
		$today = new DateTime('today');
	} else {
		$today = new DateTime($dtp);
	}
    $year = $dob->diff($today)->y;
    $month = $dob->diff($today)->m;
    $day = $dob->diff($today)->d;
	$idade_fim = array();
	$idade_fim[] = $year;
	$idade_fim[] = $month;
	$idade_fim[] = $day;
	return $idade_fim;
}
// Calcula a idade (em dias) com uma data tipo int AAAA-MM-DD e uma data de referência que se não for informada será a data de HOJE - retorna int (dias)
// ###############################################################################################################################################
function idadedias($data,$dtp=0){ // data int 2021-02-25
	$dob = new DateTime($data);
	if ($dtp == 0){
		$today = new DateTime('today');
	} else {
		$today = new DateTime($dtp);
	}
    $day = ($dob->diff($today)->y * 365) + ($dob->diff($today)->m * 30) + $dob->diff($today)->d;
	return $day;
}
// Soma ou subtrai dias em uma data
// ###############################################################################################################################################
function datasomadias($data,$dias=0,$operador='+'){  // $data int 20210225 e retorna int Ymd
	$novadata = $data;
	$ano = (int) substr($data,0,4);
	$mes = (int) substr($data,4,2);
	$dia = (int) substr($data,6,2);
	$tdia = "days";
	if ($dias == 1){
		$tdia = "day";
	}
	$novadata = date('Ymd', strtotime($operador.$dias.' '.$tdia, strtotime($dia.'-'.$mes.'-'.$ano)));
	return $novadata;
}
// Soma ou subtrai meses em uma data
// ###############################################################################################################################################
function datasomameses($data,$meses=0,$operador='+'){  // $data int 20210225 e retorna int Ymd
	$novadata = $data;
	$ano = (int) substr($data,0,4);
	$mes = (int) substr($data,4,2);
	$dia = (int) substr($data,6,2);
	/*
	$tmes = "months";
	if ($meses == 1){
		$tmes = "month";
	}
	*/
	$tmes = "month";
	$novadata = date('Ymd', strtotime($operador.$meses.' '.$tmes, strtotime($dia.'-'.$mes.'-'.$ano)));
	//date("d/m/Y",strtotime(date("Y-m-d",strtotime($data_de_referencia))."-12 month"));
	//date("d/m/Y",strtotime(date("Y-m-d")."+12 month"));
	return $novadata;
}
// Calcula o semestre
// ###############################################################################################################################################
function semestrem($data,$numm=6){  // $data int 20210225 e retorna int Ymd
	$novadata = $data;
	$ano = (int) substr($data,0,4);
	$mes = (int) substr($data,4,2);
	$dia = (int) substr($data,6,2);
	$ultimo_dia = false;
	switch ($mes) {
		case 1:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
		case 2:
			/*
			$dia_fev = 28;
			if (($ano % 4) == 0 && ($ano % 100) != 0){
				$dia_fev = 29;
			}
			if (($ano % 400) == 0 && ($ano % 100) == 0){
				$dia_fev = 29;
			}
			if ($dia == $dia_fev)
				$ultimo_dia = true;
			*/
			if ($dia == 28 || $dia == 29)
				$ultimo_dia = true;
			break;
		case 3:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
		case 4:
			if ($dia == 30)
				$ultimo_dia = true;
			break;
		case 5:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
		case 6:
			if ($dia == 30)
				$ultimo_dia = true;
			break;
		case 7:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
		case 8:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
		case 9:
			if ($dia == 30)
				$ultimo_dia = true;
			break;
		case 10:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
		case 11:
			if ($dia == 30)
				$ultimo_dia = true;
			break;
		case 12:
			if ($dia == 31)
				$ultimo_dia = true;
			break;
	}
	if ($mes > $numm){
		$mes = $mes - $numm;
	} else {
		$mes = 12 - ($numm - $mes);
		$ano--;
	}
	if ($ultimo_dia){
		$mes++;
		$dia = 1;
	}
	if (strlen($dia) == 1){
		$dia = '0'.$dia;
	}
	if (strlen($mes) == 1){
		$mes = '0'.$mes;
	}
	$novadata = $ano.$mes.$dia;
	return $novadata;
}
// ###############################################################################################################################################
function unique_multidim_array($array, $key) {
    $temp_array = array();
    $i = 0;
    $key_array = array();
	$zero_array = array();
    foreach($array as $val) {
		if (!in_array($val[$key], $key_array)) {
			$key_array[$i] = $val[$key];
			$temp_array[$i] = $val;
			$i++;
		} else {
			if ($val[$key] == '0'){
				$temp_array[$i] = $val;
				$i++;	
			}
		}
    }
    return $temp_array;
}
// Remove acentos das letras
// ###############################################################################################################################################
function tirap($str) {
	$map = array();
	$map[0][0]  = "Ã"; $map[0][1]  = "A";
	$map[1][0]  = "Â"; $map[1][1]  = "A";
	$map[2][0]  = "Á"; $map[2][1]  = "A";
	$map[3][0]  = "À"; $map[3][1]  = "A";
	$map[4][0]  = "Ä"; $map[4][1]  = "A";
	$map[5][0]  = "ã"; $map[5][1]  = "a";
	$map[6][0]  = "á"; $map[6][1]  = "a";
	$map[7][0]  = "à"; $map[7][1]  = "a";
	$map[8][0]  = "ä"; $map[8][1]  = "a";
	$map[9][0]  = "Ê"; $map[9][1]  = "E";
	$map[10][0] = "É"; $map[10][1] = "E";
	$map[11][0] = "È"; $map[11][1] = "E";
	$map[12][0] = "Ë"; $map[12][1] = "E";
	$map[13][0] = "ê"; $map[13][1] = "e";
	$map[14][0] = "é"; $map[14][1] = "e";
	$map[15][0] = "è"; $map[15][1] = "e";
	$map[16][0] = "ë"; $map[16][1] = "e";
	$map[17][0] = "Î"; $map[17][1] = "I";
	$map[18][0] = "Í"; $map[18][1] = "I";
	$map[19][0] = "Ì"; $map[19][1] = "I";
	$map[20][0] = "Ï"; $map[20][1] = "I";
	$map[21][0] = "î"; $map[21][1] = "i";
	$map[22][0] = "í"; $map[22][1] = "i";
	$map[23][0] = "ì"; $map[23][1] = "i";
	$map[24][0] = "ï"; $map[24][1] = "i";
	$map[25][0] = "Õ"; $map[25][1] = "O";
	$map[26][0] = "Ô"; $map[26][1] = "O";
	$map[27][0] = "Ó"; $map[27][1] = "O";
	$map[28][0] = "Ò"; $map[28][1] = "O";
	$map[29][0] = "Ö"; $map[29][1] = "O";
	$map[30][0] = "õ"; $map[30][1] = "o";
	$map[31][0] = "ó"; $map[31][1] = "o";
	$map[32][0] = "ò"; $map[32][1] = "o";
	$map[33][0] = "ö"; $map[33][1] = "o";
	$map[34][0] = "ô"; $map[34][1] = "o";
	$map[35][0] = "â"; $map[35][1] = "a";
	$map[36][0] = "Ç"; $map[36][1] = "C";
	$map[37][0] = "ç"; $map[37][1] = "c";
	$map[38][0] = "Ñ"; $map[38][1] = "N";
	$map[39][0] = "ñ"; $map[39][1] = "n";
	$map[40][0] = "Û"; $map[40][1] = "U";
	$map[41][0] = "Ú"; $map[41][1] = "U";
	$map[42][0] = "Ù"; $map[42][1] = "U";
	$map[43][0] = "Ü"; $map[43][1] = "U";
	$map[44][0] = "û"; $map[44][1] = "u";
	$map[45][0] = "ú"; $map[45][1] = "u";
	$map[46][0] = "ù"; $map[46][1] = "u";
	$map[47][0] = "ü"; $map[47][1] = "u";
	$map[48][0] = "–"; $map[48][1] = "";
	$map[49][0] = "ª"; $map[49][1] = "";
	$map[50][0] = "º"; $map[50][1] = "";
	$map[51][0] = "°"; $map[51][1] = "";
	$map[52][0] = "“"; $map[52][1] = "";
	$map[53][0] = "”"; $map[53][1] = "";
	$map[54][0] = "'"; $map[54][1] = "";
	$map[55][0] = "´"; $map[55][1] = "";
	$map[56][0] = "`"; $map[56][1] = "";
	for ($i=0;$i<count($map);$i++){
		$str = str_replace($map[$i][0], $map[$i][1], $str);
	}
	return $str;
}
// Tira formatação de telefone
// ###############################################################################################################################################
function tirat($str) {
	$map = array();
	$map[0][0] = "("; $map[0][1] = "";
	$map[1][0] = ")"; $map[1][1] = "";
	$map[2][0] = "{"; $map[2][1] = "";
	$map[3][0] = "}"; $map[3][1] = "";
	$map[4][0] = "["; $map[4][1] = "";
	$map[5][0] = "]"; $map[5][1] = "";
	$map[6][0] = "/"; $map[6][1] = "";
	$map[7][0] = "-"; $map[7][1] = "";
	$map[8][0] = " "; $map[8][1] = "";
	$map[9][0] = "."; $map[9][1] = "";
	$map[10][0] = ","; $map[10][1] = "";
	$map[11][0] = ";"; $map[11][1] = "";
	$map[12][0] = "_"; $map[12][1] = "";
	for ($i=0;$i<count($map);$i++){
		$str = str_replace($map[$i][0], $map[$i][1], $str);
	}
	return $str;
}
// Tira acento codificado
// ###############################################################################################################################################
function tiracento($str) {
	$map = array();
	$map[0][0]  = 'Ã'; $map[0][1]  = 'A';
	$map[1][0]  = 'Â'; $map[1][1]  = 'A';
	$map[2][0]  = 'Á'; $map[2][1]  = 'A';
	$map[3][0]  = 'À'; $map[3][1]  = 'A';
	$map[4][0]  = 'Ä'; $map[4][1]  = 'A';
	$map[5][0]  = 'ã'; $map[5][1]  = 'a';
	$map[6][0]  = 'á'; $map[6][1]  = 'a';
	$map[7][0]  = 'à'; $map[7][1]  = 'a';
	$map[8][0]  = 'ä'; $map[8][1]  = 'a';
	$map[9][0]  = 'Ê'; $map[9][1]  = 'E';
	$map[10][0] = 'É'; $map[10][1] = 'E';
	$map[11][0] = 'È'; $map[11][1] = 'E';
	$map[12][0] = 'Ë'; $map[12][1] = 'E';
	$map[13][0] = 'ê'; $map[13][1] = 'e';
	$map[14][0] = 'é'; $map[14][1] = 'e';
	$map[15][0] = 'è'; $map[15][1] = 'e';
	$map[16][0] = 'ë'; $map[16][1] = 'e';
	$map[17][0] = 'Î'; $map[17][1] = 'I';
	$map[18][0] = 'Í'; $map[18][1] = 'I';
	$map[19][0] = 'Ì'; $map[19][1] = 'I';
	$map[20][0] = 'Ï'; $map[20][1] = 'I';
	$map[21][0] = 'î'; $map[21][1] = 'i';
	$map[22][0] = 'í'; $map[22][1] = 'i';
	$map[23][0] = 'ì'; $map[23][1] = 'i';
	$map[24][0] = 'ï'; $map[24][1] = 'i';
	$map[25][0] = 'Õ'; $map[25][1] = 'O';
	$map[26][0] = 'Ô'; $map[26][1] = 'O';
	$map[27][0] = 'Ó'; $map[27][1] = 'O';
	$map[28][0] = 'Ò'; $map[28][1] = 'O';
	$map[29][0] = 'Ö'; $map[29][1] = 'O';
	$map[30][0] = 'õ'; $map[30][1] = 'o';
	$map[31][0] = 'ó'; $map[31][1] = 'o';
	$map[32][0] = 'ò'; $map[32][1] = 'o';
	$map[33][0] = 'ö'; $map[33][1] = 'o';
	$map[34][0] = 'ô'; $map[34][1] = 'o';
	$map[35][0] = 'â'; $map[35][1] = 'a';
	$map[36][0] = 'Ç'; $map[36][1] = 'C';
	$map[37][0] = 'ç'; $map[37][1] = 'c';
	$map[38][0] = 'Ñ'; $map[38][1] = 'N';
	$map[39][0] = 'ñ'; $map[39][1] = 'n';
	$map[40][0] = 'Û'; $map[40][1] = 'U';
	$map[41][0] = 'Ú'; $map[41][1] = 'U';
	$map[42][0] = 'Ù'; $map[42][1] = 'U';
	$map[43][0] = 'Ü'; $map[43][1] = 'U';
	$map[44][0] = 'û'; $map[44][1] = 'u';
	$map[45][0] = 'ú'; $map[45][1] = 'u';
	$map[46][0] = 'ù'; $map[46][1] = 'u';
	$map[47][0] = 'ü'; $map[47][1] = 'u';
	$map[48][0] = '–'; $map[48][1] = '/';
	$map[49][0] = 'ª'; $map[49][1] = '';
	$map[50][0] = 'º'; $map[50][1] = '';
	$map[51][0] = '°'; $map[51][1] = '';
	$map[52][0] = '“'; $map[52][1] = '';
	$map[53][0] = '”'; $map[53][1] = '';
	$map[54][0] = "'"; $map[54][1] = '';
	for ($i=0;$i<count($map);$i++){
		$str = str_replace(utf8_decode($map[$i][0]), $map[$i][1], $str);
	}
	return $str;
}
// Valida CNS
// ###############################################################################################################################################
function validaCNS($cns){
	if (strlen(trim($cns)) != 15){
		return false;
	}
	if (substr($cns,0,1) == 1 || substr($cns,0,1) == 2){
		$pis = substr($cns,0,11);
		$soma = substr($pis,0,1) * 15;
		$soma = $soma + substr($pis,1,1) * 14;
		$soma = $soma + substr($pis,2,1) * 13;
		$soma = $soma + substr($pis,3,1) * 12;
		$soma = $soma + substr($pis,4,1) * 11;
		$soma = $soma + substr($pis,5,1) * 10;
		$soma = $soma + substr($pis,6,1) * 9;
		$soma = $soma + substr($pis,7,1) * 8;
		$soma = $soma + substr($pis,8,1) * 7;
		$soma = $soma + substr($pis,9,1) * 6;
		$soma = $soma + substr($pis,10,1) * 5;
		$resto = $soma % 11;
		$dv = 11 - $resto;
		if ($dv == 11){
			$dv = 0;
		}
		if ($dv == 10){
			$soma = $soma + 2;
			$resto = $soma % 11;
			$dv = 11 - $resto;
			$resultado = $pis."001".$dv;
		}
		else{
			$resultado = $pis."000".$dv;
		}
		if ($cns != $resultado){
			return false;
		} else{
			return true;
		}
	} else {
		if (substr($cns,0,1) == 7 || substr($cns,0,1) == 8 || substr($cns,0,1) == 9){
			$soma = substr($cns,0,1) * 15;
			$soma = $soma + substr($cns,1,1) * 14;
			$soma = $soma + substr($cns,2,1) * 13;
			$soma = $soma + substr($cns,3,1) * 12;
			$soma = $soma + substr($cns,4,1) * 11;
			$soma = $soma + substr($cns,5,1) * 10;
			$soma = $soma + substr($cns,6,1) * 9;
			$soma = $soma + substr($cns,7,1) * 8;
			$soma = $soma + substr($cns,8,1) * 7;
			$soma = $soma + substr($cns,9,1) * 6;
			$soma = $soma + substr($cns,10,1) * 5;
			$soma = $soma + substr($cns,11,1) * 4;
			$soma = $soma + substr($cns,12,1) * 3;
			$soma = $soma + substr($cns,13,1) * 2;
			$soma = $soma + substr($cns,14,1) * 1;
			$resto = $soma % 11;
			if ($resto != 0){
				return false;
			} else{
				return true;
			}
		} else {
			return false;
		}
	}
}
// Valida CPF
// ###############################################################################################################################################
function validaCPF($cpf) {
    $cpf = preg_replace( '/[^0-9]/is', '', $cpf );
    if (strlen($cpf) != 11) {
        return false;
    }
    if (preg_match('/(\d)\1{10}/', $cpf)) {
        return false;
    }
    for ($t = 9; $t < 11; $t++) {
        for ($d = 0, $c = 0; $c < $t; $c++) {
            $d += $cpf[$c] * (($t + 1) - $c);
        }
        $d = ((10 * $d) % 11) % 10;
        if ($cpf[$c] != $d) {
            return false;
        }
    }
    return true;
}
// Informa o quadrimestre fechado
// ###############################################################################################################################################
function qfechado(){
	$final = "";
	$ano = (int) date("Y");
	$quadrimestre = 1;
	switch (date("m")) {
	  case "01":
		$quadrimestre = 1;
		break;
	  case "02":
		$quadrimestre = 1;
		break;
	  case "03":
		$quadrimestre = 1;
		break;
	  case "04":
		$quadrimestre = 1;
		break;
	  case "05":
		$quadrimestre = 2;
		break;
	  case "06":
		$quadrimestre = 2;
		break;
	  case "07":
		$quadrimestre = 2;
		break;
	  case "08":
		$quadrimestre = 2;
		break;
	  case "09":
		$quadrimestre = 3;
		break;
	  case "10":
		$quadrimestre = 3;
		break;
	  case "11":
		$quadrimestre = 3;
		break;
	  case "12":
		$quadrimestre = 3;
		break;
	  default:
		$quadrimestre = 1;
	}
	if ($quadrimestre == 3){
		$qant = 2;
	}
	if ($quadrimestre == 2){
		$qant = 1;
	}
	if ($quadrimestre == 1){
		$qant = 3;
		$ano--;
	}
	$final = "Q".$qant."/".$ano;
	return $final;
}
// Informa o quadrimestre atual
// ###############################################################################################################################################
function qatual(){
	$final = "";
	$ano = (int) date("Y");
	$quadrimestre = 1;
	switch (date("m")) {
	  case "01":
		$quadrimestre = 1;
		break;
	  case "02":
		$quadrimestre = 1;
		break;
	  case "03":
		$quadrimestre = 1;
		break;
	  case "04":
		$quadrimestre = 1;
		break;
	  case "05":
		$quadrimestre = 2;
		break;
	  case "06":
		$quadrimestre = 2;
		break;
	  case "07":
		$quadrimestre = 2;
		break;
	  case "08":
		$quadrimestre = 2;
		break;
	  case "09":
		$quadrimestre = 3;
		break;
	  case "10":
		$quadrimestre = 3;
		break;
	  case "11":
		$quadrimestre = 3;
		break;
	  case "12":
		$quadrimestre = 3;
		break;
	  default:
		$quadrimestre = 1;
	}
	$final = "Q".$quadrimestre."/".$ano;
	return $final;
}
// Informa o nome do mês
// ###############################################################################################################################################
function nmes($mes,$nm=1){ // 1, 2, 3, ... 12
	$nomem1 = '';
	$nomem2 = '';
	switch ($mes) {
	  case 1:
		$nomem1 = 'JAN';
		$nomem2 = 'JANEIRO';
		break;
	  case 2:
		$nomem1 = 'FEV';
		$nomem2 = 'FEVEREIRO';
		break;
	  case 3:
		$nomem1 = 'MAR';
		$nomem2 = 'MARCO';
		break;
	  case 4:
		$nomem1 = 'ABR';
		$nomem2 = 'ABRIL';
		break;
	  case 5:
		$nomem1 = 'MAI';
		$nomem2 = 'MAIO';
		break;
	  case 6:
		$nomem1 = 'JUN';
		$nomem2 = 'JUNHO';
		break;
	  case 7:
		$nomem1 = 'JUL';
		$nomem2 = 'JULHO';
		break;
	  case 8:
		$nomem1 = 'AGO';
		$nomem2 = 'AGOSTO';
		break;
	  case 9:
		$nomem1 = 'SET';
		$nomem2 = 'SETEMBRO';
		break;
	  case 10:
		$nomem1 = 'OUT';
		$nomem2 = 'OUTUBRO';
		break;
	  case 11:
		$nomem1 = 'NOV';
		$nomem2 = 'NOVEMBRO';
		break;
	  case 12:
		$nomem1 = 'DEZ';
		$nomem2 = 'DEZEMBRO';
		break;
	  default:
		$nomem1 = 'JAN';
		$nomem2 = 'JANEIRO';
	}
	$nf = $nomem2;
	if ($nm == 1){
		$nf = $nomem1;
	}
	return $nf;
}
// Informa o quadrimestre da data indicada
// ###############################################################################################################################################
function qdata($data){ // data no formato yyyymmdd
	$final = "";
	$ano = substr($data,0,4);
	$mes = substr($data,4,2);
	$quadrimestre = 1;
	switch ($mes) {
	  case "01":
		$quadrimestre = 1;
		break;
	  case "02":
		$quadrimestre = 1;
		break;
	  case "03":
		$quadrimestre = 1;
		break;
	  case "04":
		$quadrimestre = 1;
		break;
	  case "05":
		$quadrimestre = 2;
		break;
	  case "06":
		$quadrimestre = 2;
		break;
	  case "07":
		$quadrimestre = 2;
		break;
	  case "08":
		$quadrimestre = 2;
		break;
	  case "09":
		$quadrimestre = 3;
		break;
	  case "10":
		$quadrimestre = 3;
		break;
	  case "11":
		$quadrimestre = 3;
		break;
	  case "12":
		$quadrimestre = 3;
		break;
	  default:
		$quadrimestre = 1;
	}
	$final = "Q".$quadrimestre."/".$ano;
	return $final;
}
// Calcula a diferença de dias entre duas datas (retorna número de dias)
// ###############################################################################################################################################
function difdatas($data1,$data2){ // as duas datas no formato yyyymmdd (dt1 menor que dt2)
	$data1 = substr($data1,0,4)."-".substr($data1,4,2)."-".substr($data1,6,2);
	$data2 = substr($data2,0,4)."-".substr($data2,4,2)."-".substr($data2,6,2);
	$d1 = strtotime($data1); 
	$d2 = strtotime($data2);
	$dataFinal = ($d2 - $d1) /86400;
	if($dataFinal < 0)
	  $dataFinal *= -1;
	return  $dataFinal;	
}
// Calcula a diferença de dias entre duas datas (retorna uma matriz com 0DD 1MM 2AAAA 3SEMANA)
// ###############################################################################################################################################
function difdtl($data1,$data2){ // as duas datas no formato yyyymmdd (dt1 menor que dt2)
	$dias = 0;
	$meses = 0;
	$anos = 0;
	$semanas = 0;
	$resultado = array();
	$data1 = substr($data1,0,4)."-".substr($data1,4,2)."-".substr($data1,6,2);
	$data2 = substr($data2,0,4)."-".substr($data2,4,2)."-".substr($data2,6,2);
	$d1 = strtotime($data1); 
	$d2 = strtotime($data2);
	$dias = ($d2 - $d1) / 86400;
	if($dias < 0) {
	  $dias *= -1;
	}
	if ($dias > 31){
		$meses = floor($dias / 31);
	}
	if ($dias > 365){
		$anos = floor($dias / 365);
	}
	if ($dias > 7){
		$semanas = floor($dias / 7);
	}
	$resultado[0] = $dias;
	$resultado[1] = $meses;
	$resultado[2] = $anos;
	$resultado[3] = $semanas;
	return $resultado;
}
// ###############################################################################################################################################
function dsemanas($data1,$data2){ // as duas datas no formato yyyymmdd (dt1 menor que dt2)
	$data1 = substr($data1,0,4)."-".substr($data1,4,2)."-".substr($data1,6,2);
	$data2 = substr($data2,0,4)."-".substr($data2,4,2)."-".substr($data2,6,2);
	$d1 = strtotime($data1); 
	$d2 = strtotime($data2);
	$dias = ($d2 - $d1) /86400;
	if($dias < 0){
		$dias *= -1;
	}
	$semanas = floor($dias) / 7;
	return  floor($semanas);	
}
//*********************************************************************************************
//**********************************    PIX    ************************************************
//*********************************************************************************************
/*
 * Returns CRC16 of a string as int value
 */
function CRC16($str){
    static $CRC16_Lookup = array(
            0x0000, 0x1021, 0x2042, 0x3063, 0x4084, 0x50A5, 0x60C6, 0x70E7, 
            0x8108, 0x9129, 0xA14A, 0xB16B, 0xC18C, 0xD1AD, 0xE1CE, 0xF1EF, 
            0x1231, 0x0210, 0x3273, 0x2252, 0x52B5, 0x4294, 0x72F7, 0x62D6, 
            0x9339, 0x8318, 0xB37B, 0xA35A, 0xD3BD, 0xC39C, 0xF3FF, 0xE3DE, 
            0x2462, 0x3443, 0x0420, 0x1401, 0x64E6, 0x74C7, 0x44A4, 0x5485, 
            0xA56A, 0xB54B, 0x8528, 0x9509, 0xE5EE, 0xF5CF, 0xC5AC, 0xD58D, 
            0x3653, 0x2672, 0x1611, 0x0630, 0x76D7, 0x66F6, 0x5695, 0x46B4, 
            0xB75B, 0xA77A, 0x9719, 0x8738, 0xF7DF, 0xE7FE, 0xD79D, 0xC7BC, 
            0x48C4, 0x58E5, 0x6886, 0x78A7, 0x0840, 0x1861, 0x2802, 0x3823, 
            0xC9CC, 0xD9ED, 0xE98E, 0xF9AF, 0x8948, 0x9969, 0xA90A, 0xB92B, 
            0x5AF5, 0x4AD4, 0x7AB7, 0x6A96, 0x1A71, 0x0A50, 0x3A33, 0x2A12, 
            0xDBFD, 0xCBDC, 0xFBBF, 0xEB9E, 0x9B79, 0x8B58, 0xBB3B, 0xAB1A, 
            0x6CA6, 0x7C87, 0x4CE4, 0x5CC5, 0x2C22, 0x3C03, 0x0C60, 0x1C41, 
            0xEDAE, 0xFD8F, 0xCDEC, 0xDDCD, 0xAD2A, 0xBD0B, 0x8D68, 0x9D49, 
            0x7E97, 0x6EB6, 0x5ED5, 0x4EF4, 0x3E13, 0x2E32, 0x1E51, 0x0E70, 
            0xFF9F, 0xEFBE, 0xDFDD, 0xCFFC, 0xBF1B, 0xAF3A, 0x9F59, 0x8F78, 
            0x9188, 0x81A9, 0xB1CA, 0xA1EB, 0xD10C, 0xC12D, 0xF14E, 0xE16F, 
            0x1080, 0x00A1, 0x30C2, 0x20E3, 0x5004, 0x4025, 0x7046, 0x6067, 
            0x83B9, 0x9398, 0xA3FB, 0xB3DA, 0xC33D, 0xD31C, 0xE37F, 0xF35E, 
            0x02B1, 0x1290, 0x22F3, 0x32D2, 0x4235, 0x5214, 0x6277, 0x7256, 
            0xB5EA, 0xA5CB, 0x95A8, 0x8589, 0xF56E, 0xE54F, 0xD52C, 0xC50D, 
            0x34E2, 0x24C3, 0x14A0, 0x0481, 0x7466, 0x6447, 0x5424, 0x4405, 
            0xA7DB, 0xB7FA, 0x8799, 0x97B8, 0xE75F, 0xF77E, 0xC71D, 0xD73C, 
            0x26D3, 0x36F2, 0x0691, 0x16B0, 0x6657, 0x7676, 0x4615, 0x5634, 
            0xD94C, 0xC96D, 0xF90E, 0xE92F, 0x99C8, 0x89E9, 0xB98A, 0xA9AB, 
            0x5844, 0x4865, 0x7806, 0x6827, 0x18C0, 0x08E1, 0x3882, 0x28A3, 
            0xCB7D, 0xDB5C, 0xEB3F, 0xFB1E, 0x8BF9, 0x9BD8, 0xABBB, 0xBB9A, 
            0x4A75, 0x5A54, 0x6A37, 0x7A16, 0x0AF1, 0x1AD0, 0x2AB3, 0x3A92, 
            0xFD2E, 0xED0F, 0xDD6C, 0xCD4D, 0xBDAA, 0xAD8B, 0x9DE8, 0x8DC9, 
            0x7C26, 0x6C07, 0x5C64, 0x4C45, 0x3CA2, 0x2C83, 0x1CE0, 0x0CC1, 
            0xEF1F, 0xFF3E, 0xCF5D, 0xDF7C, 0xAF9B, 0xBFBA, 0x8FD9, 0x9FF8, 
            0x6E17, 0x7E36, 0x4E55, 0x5E74, 0x2E93, 0x3EB2, 0x0ED1, 0x1EF0
    );
    
    $crc16 = 0xFFFF; // the CRC
    $len = strlen($str);
    
    for($i = 0; $i < $len; $i++ )
    {
        $t = ($crc16 >> 8) ^ ord($str[$i]); // High byte Xor Message Byte to get index
        $crc16 = (($crc16 << 8) & 0xffff) ^ $CRC16_Lookup[$t]; // Update the CRC from table
    }
    
    // crc16 now contains the CRC value
    return $crc16;
}
/*
 * Returns CRC16 of a string as hexadecimal string
 */
function CRC16HexDigest($str){
	return sprintf('%04X', crc16($str));
}
//*********************************************************************************************
//**********************************    PIX    ************************************************
//*********************************************************************************************
?>